/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import javax.imageio.ImageIO;
import mobac.utilities.Utilities;
import org.openstreetmap.gui.jmapviewer.interfaces.MapSource;
import org.openstreetmap.gui.jmapviewer.interfaces.TileImageCache;

public class Tile {
    public static BufferedImage LOADING_IMAGE;
    public static BufferedImage ERROR_IMAGE;
    protected MapSource mapSource;
    protected int xtile;
    protected int ytile;
    protected int zoom;
    protected BufferedImage image;
    protected String key;
    protected TileState tileState = TileState.TS_NEW;

    public Tile(MapSource mapSource, int xtile, int ytile, int zoom) {
        this.mapSource = mapSource;
        this.xtile = xtile;
        this.ytile = ytile;
        this.zoom = zoom;
        this.image = LOADING_IMAGE;
        this.key = Tile.getTileKey(mapSource, xtile, ytile, zoom);
    }

    public void loadPlaceholderFromCache(TileImageCache cache) {
        int tileSize = this.mapSource.getMapSpace().getTileSize();
        BufferedImage tmpImage = new BufferedImage(tileSize, tileSize, 1);
        Graphics2D g = (Graphics2D)tmpImage.getGraphics();
        for (int zoomDiff = 1; zoomDiff < 5; ++zoomDiff) {
            int zoom_low;
            int zoom_high = this.zoom + zoomDiff;
            if (zoomDiff < 3 && zoom_high <= 22) {
                int factor = 1 << zoomDiff;
                int xtile_high = this.xtile << zoomDiff;
                int ytile_high = this.ytile << zoomDiff;
                double scale = 1.0 / (double)factor;
                g.setTransform(AffineTransform.getScaleInstance(scale, scale));
                int paintedTileCount = 0;
                for (int x = 0; x < factor; ++x) {
                    for (int y = 0; y < factor; ++y) {
                        Tile tile = cache.getTile(this.mapSource, xtile_high + x, ytile_high + y, zoom_high);
                        if (tile == null || tile.tileState != TileState.TS_LOADED) continue;
                        ++paintedTileCount;
                        tile.paint(g, x * tileSize, y * tileSize);
                    }
                }
                if (paintedTileCount == factor * factor) {
                    this.image = tmpImage;
                    return;
                }
            }
            if ((zoom_low = this.zoom - zoomDiff) < 0) continue;
            int xtile_low = this.xtile >> zoomDiff;
            int ytile_low = this.ytile >> zoomDiff;
            int factor = 1 << zoomDiff;
            double scale = factor;
            AffineTransform at = new AffineTransform();
            int translate_x = this.xtile % factor * tileSize;
            int translate_y = this.ytile % factor * tileSize;
            at.setTransform(scale, 0.0, 0.0, scale, -translate_x, -translate_y);
            g.setTransform(at);
            Tile tile = cache.getTile(this.mapSource, xtile_low, ytile_low, zoom_low);
            if (tile == null || tile.tileState != TileState.TS_LOADED) continue;
            tile.paint(g, 0, 0);
            this.image = tmpImage;
            return;
        }
    }

    public void setErrorImage() {
        this.image = ERROR_IMAGE;
        this.tileState = TileState.TS_ERROR;
    }

    public void loadImage(InputStream input) throws IOException {
        this.image = ImageIO.read(input);
    }

    public String getKey() {
        return this.key;
    }

    public TileState getTileState() {
        return this.tileState;
    }

    public void setTileState(TileState tileState) {
        this.tileState = tileState;
    }

    public HttpURLConnection getUrlConnection() throws IOException {
        return this.mapSource.getTileUrlConnection(this.zoom, this.xtile, this.ytile);
    }

    public void paint(Graphics g, int x, int y) {
        if (this.image == null) {
            return;
        }
        g.drawImage(this.image, x, y, Color.WHITE, null);
    }

    public void paintTransparent(Graphics g, int x, int y) {
        if (this.image == null) {
            return;
        }
        g.drawImage(this.image, x, y, null);
    }

    public String toString() {
        return "Tile " + this.key;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tile)) {
            return false;
        }
        Tile tile = (Tile)obj;
        return this.xtile == tile.xtile && this.ytile == tile.ytile && this.zoom == tile.zoom;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return -1;
    }

    public static String getTileKey(MapSource source, int xtile, int ytile, int zoom) {
        return zoom + "/" + xtile + "/" + ytile + "@" + source.getName();
    }

    static {
        try {
            LOADING_IMAGE = ImageIO.read(Utilities.getResourceImageUrl("hourglass.png"));
            ERROR_IMAGE = ImageIO.read(Utilities.getResourceImageUrl("error.png"));
        }
        catch (Exception exception) {
            LOADING_IMAGE = null;
            ERROR_IMAGE = null;
        }
    }

    protected static enum TileState {
        TS_NEW,
        TS_LOADING,
        TS_LOADED,
        TS_ERROR;

    }
}

